@echo off

if not exist terrain.drs goto missing_file
if not exist drsbuild.exe goto missing_file

echo saving old terrain.drs to terrain.old

copy terrain.drs terrain.old /-Y
del %TEMP%\*.slp

drsbuild /e terrain.drs ter15000.slp /o %TEMP%
drsbuild /e terrain.drs ter15001.slp /o %TEMP%
drsbuild /e terrain.drs ter15014.slp /o %TEMP%
drsbuild /e terrain.drs ter15031.slp /o %TEMP%

ren %TEMP%\ter15000.slp ter15027.slp 
copy %TEMP%\ter15001.slp %TEMP%\ter15026.slp 
copy %TEMP%\ter15001.slp %TEMP%\ter15028.slp 
ren %TEMP%\ter15001.slp ter15029.slp 
ren %TEMP%\ter15014.slp ter15024.slp 
ren %TEMP%\ter15031.slp ter15030.slp 

drsbuild /r terrain.drs %TEMP%\*.slp
del %TEMP%\*.slp
cls
goto display

:missing_file
echo ERROR: terrain.drs and/or drsbuild.exe dont exist. 
echo make sure you are running this file in the AoK\Data\ folder
echo and check if drsbuild.exe has been extracted correctly.
echo check readme.txt for more info
goto end

:display
cls
echo 
echo           #################################################
echo           #                                               #
echo           #                                               #
echo           #              ReMove SnoW V1.0                 #
echo           #                                               #
echo           #  Snow has been replaced by standard-terrain   #
echo           #                                               #
echo           #  Original terrain.drs saved to terrain.old    #
echo           #                                               #
echo           #                                               #
echo           #                                               #
echo           #            Script by pG_plexiq :-P            #
echo           #              Copyright (C) 2000               #
echo           #                                               #
echo           #           http://www.pro-gaming.de            #
echo           #                                               #
echo           #                                               #
echo           #            (.DRS) Builder Utility             #
echo           #       Copyright (C) 1997 Stoyan Ratchev       #
echo           #                                               #
echo           #################################################




:end
@echo on